/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.filters;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.filters.DynamicChannelHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.SplitPacketPayload;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="neoforge", bus=EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class GenericPacketSplitter
extends MessageToMessageEncoder<Packet<?>>
implements DynamicChannelHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SizeLimits compressedSizeLimits = new SizeLimits(0x200000);
    private static final SizeLimits uncompressedSizeLimits = new SizeLimits(0x800000);
    private static final byte STATE_FIRST = 1;
    private static final byte STATE_LAST = 2;
    public static final String CHANNEL_HANDLER_NAME = "neoforge:splitter";
    private final List<byte[]> receivedBuffers = new ArrayList<byte[]>();

    @SubscribeEvent
    private static void register(RegisterPayloadHandlersEvent event) {
        event.registrar("1").optional().commonBidirectional(SplitPacketPayload.TYPE, SplitPacketPayload.STREAM_CODEC, GenericPacketSplitter::handle);
    }

    private static void handle(SplitPacketPayload payload, IPayloadContext context) {
        ChannelHandler channelHandler = context.channelHandlerContext().pipeline().get(CHANNEL_HANDLER_NAME);
        if (channelHandler instanceof GenericPacketSplitter) {
            GenericPacketSplitter splitter = (GenericPacketSplitter)channelHandler;
            splitter.receivedPacket(payload, context);
        } else {
            LOGGER.error("Received split packet without a splitter");
            context.disconnect((Component)Component.translatable((String)"neoforge.network.packet_splitter.unknown"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Packet<?> packet, List<Object> out) throws Exception {
        ServerboundCustomPayloadPacket serverboundCustomPayloadPacket;
        ClientboundCustomPayloadPacket clientboundCustomPayloadPacket;
        if (packet instanceof ClientboundCustomPayloadPacket && (clientboundCustomPayloadPacket = (ClientboundCustomPayloadPacket)packet).payload() instanceof SplitPacketPayload) {
            out.add(packet);
            return;
        }
        if (packet instanceof ServerboundCustomPayloadPacket && (serverboundCustomPayloadPacket = (ServerboundCustomPayloadPacket)packet).payload() instanceof SplitPacketPayload) {
            out.add(packet);
            return;
        }
        ChannelHandler channelHandler = ctx.pipeline().get("encoder");
        if (!(channelHandler instanceof PacketEncoder)) {
            out.add(packet);
            return;
        }
        PacketEncoder encoder = (PacketEncoder)channelHandler;
        boolean hasCompressor = ctx.pipeline().get("compress") != null;
        SizeLimits sizeLimits = hasCompressor ? uncompressedSizeLimits : compressedSizeLimits;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            StreamCodec codec = encoder.getProtocolInfo().codec();
            codec.encode((Object)buf, packet);
            if (buf.readableBytes() <= sizeLimits.packet()) {
                out.add(packet);
                return;
            }
            int parts = (int)Math.ceil((double)buf.readableBytes() / (double)sizeLimits.part());
            if (parts == 1) {
                out.add(packet);
                return;
            }
            byte[] packetData = buf.array();
            for (int part = 0; part < parts; ++part) {
                int prefix;
                int partSize = Math.min(sizeLimits.part(), packetData.length - part * sizeLimits.part());
                byte[] payloadSlice = new byte[partSize + 1];
                payloadSlice[0] = prefix = part == 0 ? 1 : (part == parts - 1 ? 2 : 0);
                System.arraycopy(packetData, part * sizeLimits.part(), payloadSlice, 1, partSize);
                out.add(GenericPacketSplitter.createPacket(encoder.getProtocolInfo().flow(), payloadSlice));
            }
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedPacket(SplitPacketPayload payload, IPayloadContext context) {
        byte state = payload.payload()[0];
        if (state == 1 && !this.receivedBuffers.isEmpty()) {
            LOGGER.warn("neoforge:split received out of order - inbound buffer not empty when receiving first");
            this.receivedBuffers.clear();
        }
        int contentSize = payload.payload().length - 1;
        byte[] buffer = new byte[contentSize];
        System.arraycopy(payload.payload(), 1, buffer, 0, contentSize);
        this.receivedBuffers.add(buffer);
        if (state == 2) {
            byte[][] buffers = (byte[][])this.receivedBuffers.toArray((T[])new byte[0][]);
            FriendlyByteBuf full = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[][])buffers));
            try {
                Packet packet = (Packet)context.connection().getInboundProtocol().codec().decode((Object)full);
                context.enqueueWork(() -> context.handle(packet));
            }
            finally {
                this.receivedBuffers.clear();
                full.release();
            }
        }
    }

    private static Packet<?> createPacket(PacketFlow flow, byte[] payload) {
        return switch (flow) {
            default -> throw new MatchException(null, null);
            case PacketFlow.SERVERBOUND -> new ServerboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(payload));
            case PacketFlow.CLIENTBOUND -> new ClientboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(payload));
        };
    }

    @Override
    public boolean isNecessary(Connection manager) {
        return GenericPacketSplitter.isRemoteCompatible(manager);
    }

    public static RemoteCompatibility getRemoteCompatibility(Connection manager) {
        return NetworkRegistry.hasChannel(manager, null, SplitPacketPayload.TYPE.id()) ? RemoteCompatibility.PRESENT : RemoteCompatibility.ABSENT;
    }

    public static boolean isRemoteCompatible(Connection manager) {
        return GenericPacketSplitter.getRemoteCompatibility(manager) != RemoteCompatibility.ABSENT;
    }

    public static int determineMaxPayloadSize(int maxPacketSize) {
        FriendlyByteBuf temporaryBuf = new FriendlyByteBuf(Unpooled.buffer());
        temporaryBuf.writeByte(0);
        temporaryBuf.writeResourceLocation(SplitPacketPayload.TYPE.id());
        temporaryBuf.writeByte((byte)1);
        temporaryBuf.writeVarInt(Integer.MAX_VALUE);
        temporaryBuf.writeInt(Integer.MAX_VALUE);
        int prefixSize = temporaryBuf.readableBytes();
        return maxPacketSize - prefixSize;
    }

    private record SizeLimits(int packet, int part) {
        public SizeLimits(int packet) {
            this(packet, GenericPacketSplitter.determineMaxPayloadSize(packet));
        }
    }

    public static enum RemoteCompatibility {
        ABSENT,
        PRESENT;

    }
}

